//Caption: To Design Digital IIR Butterworth LPF
//Analog cutoff freq = 1000 Hz, Sampling Freq = 10000 samples/sec
//Order of IIR filter N = 2
clc;
clear;
xdel(winsid());
fc = input('Enter cutoff freq in Hz fc =')
fs = input('Enter sampling freq in Hz fs =')
N = input('Enter order of Butterworth filterN =')
Fp = 2*fc/fs; //Pass band edge frequency in cycles/samples
[Hz]=iir(N,'lp','butt',[Fp/2,0],[0,0]) //digital IIR Butterworth Filter
[Hw,w] = frmag(Hz,256);
subplot(2,1,1)
plot(2*w,abs(Hw));
xlabel('Normalized Digital Frequency w--->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of IIR LPF')
xgrid(1)
subplot(2,1,2)
plot(2*w*fs,abs(Hw));
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of IIR LPF')
xgrid(1)
//Example
// 
//Enter cutoff freq in Hz fc =1000
//
//Enter sampling freq in Hz fs =10000
//
//Enter order of Butterworth filterN = 2
// -->Hz
// Hz  =
// 
//                                       2  
//    0.0674553 + 0.1349105z + 0.0674553z   
//    -----------------------------------   
//                                  2       
//        0.4128016 - 1.1429805z + z        